<?php 
$start = new DateTime('2014-03-03 09:21:30');
$end = new DateTime('2014-03-11 17:23:15');
// otherwise the  end date is excluded (bug?)
$end->modify('+1 day');

$interval = $end->diff($start);

// total days
$days = $interval->days;
$days_inMin = ($interval->d*24*60) + ($interval->h*60) + $interval->i;

// create an iterateable period of date (P1D equates to 1 day)
$period = new DatePeriod($start, new DateInterval('P1D'), $end);

// best stored as array, so you can add more than one
$holidays = array('2014-03-07');

foreach($period as $dt) {
    $curr = $dt->format('D');

    // for the updated question
    if (in_array($dt->format('Y-m-d'), $holidays)) {
       $days--;
       $days_inMin -= (24*60);
    }

    // substract if Saturday or Sunday
    if ($curr == 'Sat' || $curr == 'Sun') {
        $days--;
        $days_inMin -= (24*60);
    }
}

echo 'Days: ' . $days; 
echo '<br>Days in Minutes: ' . $days_inMin . ' min = ' . $days_inMin/(24*60) . ' days';

?>